#!/usr/bin/perl -w

#===============================================================================
# transfer old txt sequence file to fastq format
#===============================================================================

use strict;
use warnings;

my $inputFile = $ARGV[0];
my $outputFile = $ARGV[1];
my @array = ();

open(In, "<", $inputFile) or die "Fail to open file - $inputFile\n";
open(Out, ">", $outputFile);

while(<In>){
	chomp;
	@array = split(/\s+/, $_);
	my $head = $array[0]."\_".$array[1]."\:".$array[2]."\:".$array[3]."\:".$array[4]."\:".$array[5]."\#".$array[6]."\/".$array[7];
	my $seq = $array[8];
	my $qc = $array[9];
	print Out "\@".$head."\n";
	print Out $seq."\n";
	print Out "\+".$head."\n";
	print Out $qc."\n";
}

close(In);
close(Out);
