#!/usr/bin/perl -w

# Usage:
#   selectSpecies.pl mature.fa hsa
#   Generate a new file - mature_hsa.fa

use strict;
use warnings;


my $inputFile = $ARGV[0];
my $species = $ARGV[1];
my @array = split(/\./, $inputFile);
my $suffix;
my $prefix;

if (scalar(@array) > 1) {
	$suffix = pop(@array);
	$prefix = join('.', @array);
}
my $outputFile = $prefix."\_".$species."\.".$suffix;

open(In, "<", $inputFile) or die "Fail to open file - $inputFile\n";
open(Out, ">", $outputFile) or die "Fail to open file - $inputFile\n";

my $tag = 0;
while(<In>){
  chomp;
  if(/^>$species\-/){
    $tag = 1;
  }elsif(/^>/){
    $tag = 0;
  }
  if( $tag == 1 ){
    print Out "$_\n";
  }
}

close(In);
close(Out);


