#!/usr/bin/perl -w

#===============================================================================
# miRNA mapping for all samples
# ARGV[0]:	read assignment option
# Usage:	matchAllSamples_miR.pl --singleAssign
#			matchAllSamples_miR.pl --multiAssign
#===============================================================================

use strict;
use warnings;

my $assignOption = $ARGV[0];
if ( !$ARGV[0] ) {
	$assignOption = "--multiAssign";
}

my $dataDIR = "./";

opendir my $dir, $dataDIR or die "Cannot open directory: $dataDIR";
my @fileList = readdir $dir;
closedir $dir;

my @readFileList = grep(/\_Processed.fa$/, @fileList);
@readFileList = sort @readFileList;

print join("\t", @readFileList);
my $num = scalar(@readFileList);

if ( $num == 0 ) {
	print "\n\nThere is NO preprocessed FASTA file (_Processed.fa) in this folder\n";
	exit;
} elsif ( $num == 1 ) {
	print "\n\nThere is ".$num." preprocessed FASTA file (_Processed.fa) in this folder\n";
} else {
	print "\n\nThere are ".$num." preprocessed FASTA files (_Processed.fa) in this folder\n";
}

my $i = 0;
my $maxReadLength = 86;
foreach my $readFile (@readFileList) {
	$i++;
	print "\n====== Begin to match #".$i." read file ======";
	if ( $assignOption eq "--multiAssign" ) {			# multiple assignment - one read will be mapped to multiple reference sequences
		system("matchRNA_v1.6w_miR.pl ".$maxReadLength."\ ".$readFile);
	} elsif ( $assignOption eq "--singleAssign" ) {		# single assignment - one read will be mapped to the best-matched reference sequence based on likelihoods
		system("matchRNA_v1.6s_miR.pl ".$maxReadLength."\ ".$readFile);
	}
}

system("mkdir PisomiR");
system("mv *.profile ./PisomiR/");
system("mv *.feature ./PisomiR/");
system("mv *.dist ./PisomiR/");
system("mv *_unMatch.fa ./PisomiR/");