#!/usr/bin/perl -w

use strict;
use warnings;

my $dataDIR = "./";

opendir my $dir, $dataDIR or die "Cannot open directory: $dataDIR";
my @fileList = readdir $dir;
closedir $dir;

my @readFileList = grep(/_prinseq_1.fasta$/, @fileList);
@readFileList = sort @readFileList;

print join("\t", @readFileList);
print "\nThere are ".scalar(@readFileList)." FASTA files in this folder\n";

my $i = 0;
foreach my $readFile (@readFileList) {
	$i++;
	print "\n====== Begin to match #".$i." read file ======";
	system("matchRNA_fusion.pl ".$readFile);
}

system("mkdir Fusion");
system("mv *.fusion ./Fusion/");
system("mv *.gene ./Fusion/");