#!/usr/bin/perl -w

use strict;
use warnings;

my $dataDIR = "./";

opendir my $dir, $dataDIR or die "Cannot open directory: $dataDIR";
my @fileList = readdir $dir;
closedir $dir;

my @readFileList = grep(/\_Processed.fa$/, @fileList);
@readFileList = sort @readFileList;

print join("\t", @readFileList);
my $num = scalar(@readFileList);

if ( $num == 0 ) {
	print "\n\nThere is NO preprocessed FASTA file (_Processed.fa) in this folder\n";
	exit;
} elsif ( $num == 1 ) {
	print "\n\nThere is ".$num." preprocessed FASTA file (_Processed.fa) in this folder\n";
} else {
	print "\n\nThere are ".$num." preprocessed FASTA files (_Processed.fa) in this folder\n";
}

my $i = 0;
my $maxReadLength = 86;
foreach my $readFile (@readFileList) {
	$i++;
	print "\n====== Begin to match #".$i." read file ======";
	system("matchRNA_v1.6.5.pl ".$maxReadLength."\ ".$readFile);
}

system("mkdir PisaR");
system("mv *.profile ./PisaR/");
system("mv *.feature ./PisaR/");
system("mv *.dist ./PisaR/");
system("mv *_unMatch.fa ./PisaR/");