#!/usr/bin/perl -w

# divide all paired FASTQ files into left half and right half FASTQ files under current folder

use strict;
use warnings;

my $dataDIR = "./";

opendir my $dir, $dataDIR or die "Cannot open directory: $dataDIR";
my @fileList = readdir $dir;
closedir $dir;

my @readFileList = grep(/\.fastq$/, @fileList);
@readFileList = sort @readFileList;

print join("\t", @readFileList);
my $num = scalar(@readFileList);

if ( $num == 0 ) {
	print "\n\nThere is NO FASTQ file (.fastq) in this folder\n";
	exit;
} elsif ( $num == 1 ) {
	print "\n\nThere is ".$num." FASTQ file (.fastq) in this folder\n";
} else {
	print "\n\nThere are ".$num." FASTQ file (.fastq) in this folder\n";
}

my $i = 0;
my $maxReadLength = 50;
foreach my $readFile (@readFileList) {
	$i++;
	print "\n====== Begin to divide #".$i." FASTQ file ======\n";
	divideFASTQ($maxReadLength, $readFile);
}

# divide paired FASTQ file into left half and right half FASTQ files
sub divideFASTQ {
	my ($maxReadLength, $readFile) = @_;
	open(In, "<", $readFile);
	my $R1_File = $readFile;
	$R1_File =~ s/\.fastq$/\_R1.fastq/;
	my $R2_File = $readFile;
	$R2_File =~ s/\.fastq$/\_R2.fastq/;
	open(Left, ">", $R1_File);
	open(Right, ">", $R2_File);
	while(<In>) {
		chomp;
		if (length($_) > $maxReadLength) {
			my $leftSeq = substr($_, 0, $maxReadLength);
			my $rightSeq = substr($_, $maxReadLength, $maxReadLength);
			print Left $leftSeq."\n";
			print Right $rightSeq."\n";
		} else {
			print Left $_."\n";
			print Right $_."\n";
		}
	}
	close(In);
	close(Left);
	close(Right);
}
