#!/usr/bin/perl -w

#===============================================================================
# ARGV[0]: feature file (*_des.feature) with descrition information annotated
# by desFeature.pl
# need the file - all_sample.matchrate, generated by "sumAllSample.pl sampleOrder"
# e.g., divideFeatureH.pl all_sample_des.feature
#===============================================================================

use strict;
use warnings;

my $feature = $ARGV[0];
my $prefix = $feature;
my $suffix = "feature";
my @array = split(/\./, $feature);
if (scalar(@array) > 1) {
	$suffix = pop(@array);
	$prefix = join('.', @array);
}

# get match order (ordered by matchType, e.g., )
my @matchOrder = ();
my $refName;
my $maxMismatch;
my $matchType;
open(IN, "<", "all_sample.matchrate") or die "Can not open all_sample.matchrate !!!";;
my $firstLine = <IN>;
chomp($firstLine);
@matchOrder = split(/\t/, $firstLine);
shift(@matchOrder);
pop(@matchOrder);
close(IN);

# get input feature file
my @inputFeature = ();
open(IN, "<", $feature) or die "Can not open $feature !!!";
$firstLine = <IN>;
my $i = 0;
while (<IN>) {
	chomp;
	@array = split(/\t/, $_);
	$refName = $array[0];
	$maxMismatch = $array[3];
	$matchType = $refName."\.mis_".$maxMismatch;
	$inputFeature[$i][0] = $matchType;
	$inputFeature[$i][1] = $_;
	$i++;
}


# output divieded features (e.g., all_sample_annotated.human_miRNA_mature.mis_0.feature) for all samples
foreach $matchType (@matchOrder) {
	my $outputFile = $prefix."\.".$matchType."\.".$suffix;
	print "=== Write divieded features for all samples to: $outputFile ===\n";
	open(OUT, ">", $outputFile);
	print OUT $firstLine;
	
	for my $j (0..($i-1)) {
		if ($inputFeature[$j][0] eq $matchType) {
			print OUT $inputFeature[$j][1]."\n";
		}
	}
	close(OUT);
}
