#!/usr/bin/perl -w

#===============================================================================
# add description information to features (matchType, matchID, description, readNum)
# the description information derives from corresponding refDB (built by buildDescrition.pl)
# ARGV[0]: 	any feature file (*.feature) for single sample or all samples
# ARGV[1]:  path to the database config file
# Output: 	feature file (*_des.feature) with description information annotated 
# Usage:	desFeature.pl all_sample.feature
#===============================================================================

use strict;
use warnings;
use FindBin qw($Bin);
use lib "$Bin";
use ReadDBConfig;

my $feature = $ARGV[0];
my $db_config_file = $ARGV[1];
my %indexDes = ();
my $refName;
my $matchType;
my $matchID;
my $description;

# hash from database names to paths
my %db_names = ReadDBConfig::readDBConfig($db_config_file);

# test feature file first!!
if ( !-e $feature ) {
	die "   Can not open $feature !!!\n";
}

# get all description index
foreach $refName (keys(%db_names)) {
	print "Loading description file for ".$refName." ...\n";
	my $index = $db_names{$refName};
	$index = $index.".description";
	open(In, "<", $index) or print "need to build description index file: $index\n";
	while (<In>) {
		chomp;
		my @head = split(/\t/, $_);
		if ( scalar(@head) == 2 ) {
			$matchID = $head[0];
			$description = $head[1];
			$indexDes{$refName}{$matchID} = $description;
		}
	}
	close(In);
}

open(In, "<", $feature) or die "Can not open $feature !!!\n";
my $outputFile = $feature;
$outputFile =~ s/\.feature/_des.feature/;
open(Out, ">", $outputFile);
print "Output described feature file: $outputFile\n";

# read and output head (first line)
my $firstLine = <In>;
my @array = split(/\t/, $firstLine);
$matchType = shift(@array);
$matchID = shift(@array);
print Out $matchType."\t".$matchID."\t"."description"."\t".join("\t", @array);

# read and output data
while (<In>) {
	chomp;
	@array = split(/\t/, $_);
	$matchType = shift(@array);
	$matchID = shift(@array);
	my @head = split(/\.mis_/, $matchType);
	$refName = $head[0];
	$description = "n/a"; # annotated with 'n/a' - representing not avalable!!!
	if ( exists $indexDes{$refName}{$matchID} ) {
			$description = $indexDes{$refName}{$matchID};
	}
	# output matchType, matchID, description, ...
	print Out $matchType."\t".$matchID."\t".$description."\t".join("\t", @array)."\n";
}
close(In);
close(Out);
