package ReadDBConfig;
use Exporter;
our @EXPORT = qw(readDBConfig getBasePath);

sub getBasePath {
    my ($config_filename) = @_;
    open(my $db_file, "<", $config_filename) or die "Could not find config file";
    while (my $line = <$db_file>) {
        chomp($line);
        # remove comments, which come after the # sign
        $line =~ s/#.*//;
        # it's a blank line, so just skip it
        if ($line =~ /^\s*$/) {
            next;
        }
        my @row_list = split(":", $line);
        my $db_path = $row_list[1]; # get the db path
        my $db_name = $row_list[0]; # get the database name
        $db_name =~ s/^\s+|\s+$//g; # use rexep to trim whitespace
        $db_path =~ s/^\s+|\s+$//g;
        
        # is the format is base: /example/path
        # then it is the base path for the databases
        if ($db_name eq "base") {
            return ($db_path);
        }
    }
}


sub readDBConfig {
    my ($config_filename) = @_;
    
    # the base directory for all paths specified
    my $base_dir = "";
    # a hash table from the DB name to the path where the DB is located
    my %db_name_to_path;
    
    # open the config file
    open(my $db_file, "<", $config_filename) or die "Could not find config file";
    while (my $line = <$db_file>) {
        chomp($line);
        # remove comments, which come after the # sign
        $line =~ s/#.*//;
        # it's a blank line, so just skip it
        if ($line =~ /^\s*$/) {
            next;
        }
        my @row_list = split(":", $line);
        my $db_path = $row_list[1]; # get the db path
        my $db_name = $row_list[0]; # get the database name
        $db_name =~ s/^\s+|\s+$//g; # use rexep to trim whitespace
        $db_path =~ s/^\s+|\s+$//g;
        
        # is the format is base: /example/path
        # then it is the base path for the databases
        if ($db_name eq "base") {
            $base_dir = $db_path
        }
        else {
            my $path;
            # put the db name and path into the hash table
            if (substr($base_dir, -1) eq "/") {
                $path = $base_dir.$db_path;
            }
            else {
                $path = $base_dir."/".$db_path;
            }
            $db_name_to_path{$db_name} = $path;
        }
    }
    return (%db_name_to_path);
}